	clear all
	close all
	fs = 16; lw = 2; fn = 'times'; 
	% Requirements for the digital lowpass filter
	wcT = 0.55*pi; wsT = 0.6*pi; Amax = 0.1; Amin = 65;
	% Requirements for the analog prototype lowpass filter
	Wac = tan(wcT/2); Was = tan(wsT/2);
	% Design of the analog prototype lowpass filter
	N = CA_ORDER_S(Wac, Was, Amax, Amin) 	% Must be an integer. 	
	
	N = 9;					% We select a 3th-order filter
	[G, Z, R_ZEROS, P, Wsnew] = CA_POLES_S(Wac, Was, Amax, Amin, N);
	Rs = 1; RL = 1; Ladder = 0; Type = 'a'; % 1 for a T ladder and 0 for a  ladder	
	[L, C, Rs, RL, W0, K] = CA_LADDER(G, Z, R_ZEROS, P, Wac, Was, Amax, Amin, Rs, RL, Ladder, Type);
	Z0 = [];  	T = 2;				% Used only for transmission lines
	omega = [0:0.01:3];
	wT = linspace(0, pi, 1000); axis_Amax = 80; axis_Tg_max = 240;
	%=========	
	GC = C; Gl = 1./L; Rs = 1; RL = 1;	
	%==================== From the source side =====================
	% Adaptor I - PARALLEL
	G10 = 1/Rs + GC(1); 					
	alfa11 = 2/Rs/(1/Rs + GC(1) + G10);
	% Adaptor II - PARALLEL
	G11 = Gl(2) + GC(2);		 	
	alfa21 = 2*Gl(2)/(Gl(2) + GC(2) + G11);
	% Adaptor III - SERIES 
	R11 = 1/G11; R10 = 1/G10; R12 = R10 + R11;
	alfa31 = 2*R10/(R10 + R11 + R12);	
	%=====================================================
	% Adaptor IV - PARALLEL
	G13 = 1/R12 + GC(3);					
	alfa41 = 2/R12/(1/R12 + GC(3) + G13);
	% Adaptor V - PARALLEL	
	G14 = Gl(4) + GC(4);		
	alfa51 = 2*Gl(4)/(Gl(4) + GC(4) + G14);
	% Adaptor VI - SERIES 
	R14 = 1/G14; R13 = 1/G13; R15 = R13 + R14;
	alfa61 = 2*R13/(R13 + R14 + R15);
	%===================== From the load side ===================
	% Adaptor VII - PARALLEL
	G21 = 1/RL+ GC(9);						
	alfa71 = 2*GC(9)/(1/RL + GC(9) + G21);
	% Adaptor VIII - PARALLEL
	G20 = Gl(8) + GC(8);					
	alfa81 = 2*Gl(8)/(Gl(8) + GC(8) + G20); 
	% Adaptor IX - SERIES 
	R20 = 1/G20; R21 = 1/G21; R19 = R20 + R21;
	alfa91 = 2*R20/(R20 + R21 + R19);
	%=====================================================
	% Adaptor X - PARALLEL
	G18 = 1/R19 + GC(7);					
	alfa101 = 2*GC(7)/(1/R19 + GC(7) + G18);
	G17 = Gl(6) + GC(6);						
	% Adaptor XI - PARALLEL
	alfa111 = 2*Gl(6)/(Gl(6) + GC(6) + G17) ;
	% Adaptor XII - SERIES
	R17 = 1/G17; R18 = 1/G18;	R16 = R17 + R18;
	alfa121 = 2*R17/(R16 + R17 + R18);
	%=====================================================						
	% Adaptor XIII - PARALLEL
	G16 = 1/R16; 	G15 = 1/R15;			
	alfa131 = 2*GC(5)/(G15 + GC(5) + G16);
	alfa132 = 2*G15/(G15 + GC(5) + G16);
	%=====================================================
	c1 = 1/sqrt( 1.41008263383545);
	c2 = sqrt(0.83925662903450);   
	c3 = 1/sqrt(0.86695461093128);
	c4 = 1/sqrt(0.48738698229645);
	c5 = sqrt( 1.22020099188818);
	c6 = 1/sqrt(0.79932058389458); 
	c7 = sqrt(2.80215709310754);
	c8 = sqrt(0.36818559161908);
	c9 = sqrt( 0.57456131129541); 
	c10 = sqrt(2.10208399996890); 
	c11 = sqrt(1.06298096815364); 
	c12 = sqrt(0.48594892471926); 
	c13 = sqrt(0.90331885110119); 
	c14 = 1/sqrt(0.73820435177475); 
	%===========     
	delta = 2^-7;
	for nn = 1:100
		alfa11R = alfa11 + delta*(rand(1,length(alfa11))-0.5);
		alfa21R = alfa21 + delta*(rand(1,length(alfa21))-0.5);
		alfa31R = alfa31 + delta*(rand(1,length(alfa31))-0.5);	
		alfa41R = alfa41 + delta*(rand(1,length(alfa41))-0.5);
		alfa51R = alfa51 + delta*(rand(1,length(alfa51))-0.5);
		alfa61R = alfa61 + delta*(rand(1,length(alfa61))-0.5);
		alfa71R = alfa71 + delta*(rand(1,length(alfa71))-0.5);
		alfa81R = alfa81 + delta*(rand(1,length(alfa81))-0.5);	
		alfa91R = alfa91 + delta*(rand(1,length(alfa91))-0.5);
		alfa101R = alfa101 + delta*(rand(1,length(alfa101))-0.5);
		alfa111R = alfa111 + delta*(rand(1,length(alfa111))-0.5);
		alfa121R = alfa121 + delta*(rand(1,length(alfa121))-0.5);
		alfa131R = alfa131 + delta*(rand(1,length(alfa131))-0.5);
		alfa132R = alfa132 + delta*(rand(1,length(alfa132))-0.5);
		%=====================================================
		a1 = 1; a2 = 0; v1 = 0; v2 = 0; v3 = 0; v4 = 0; v5 = 0; v6 = 0; 
		v7 = 0; v8 = 0; v9 = 0; v10 = 0; v11 = 0; v12 = 0; v13 = 0;
		for n = 1:20
			% Adaptor I
			T11 = v1 - a1*c1;
			T12 = -alfa11R*T11; 
			x1 = (T12 + v1); 
			x1s = x1*c3;
			% Adaptor II 
			T21 = v3 + v2;
			T22 = -alfa21R*T21; 
			x2 = (T22 + v3); 
			x2s = x2*c2;
			% Adaptor III - Series
			x3 = -(x1s + x2s);
			x3s = x3*c4;
			% Adaptor IV	
			T41 = v4 - x3s;
			T42 = -alfa41R*T41; 
			x4 = (T42 + v4);
			x4s = x4*c6;
			% Adaptor V
			T51 = v6 + v5;
			T52 = -alfa51R*T51; 
			x5 = (T52 + v6);
			x5s = x5*c5;
			% Adaptor VI - Series
			x6 = -(x4s + x5s);
			x6s = x6*c14;
			% Adaptor VII
			T71 = a2*c7 - v13; 
			T72 = -alfa71R*T71; 
			x12 = (T72 + a2*c7);
			x12s = x12*c9;
			% Adaptor VIII
			T81 = v12 + v11;
			T82 = -alfa81R*T81; 
			x11 = (T82 + v12);
			x11s = x11*c8;
			% Adaptor IX -series
			x10 = -(x11s + x12s);
			x10s = x10*c10;
			% Adaptor X	
			T101 = x10s - v10;
			T102 = -alfa101R*T101; 
			x9 = (T102 + x10s);
			x9s = x9*c12;
			% Adaptor XI
			T111 = v9 + v8; 
			T112 = -alfa111R*T111; 
			x8 = (T112 + v9);
			x8s = x8*c11;
			% Adaptor XII -series
			x7 = -(x8s + x9s);
			x7s = x7*c13;
			% Adaptor XIII
			T131 = x7s - v7; 
			T132 = x7s - x6s; 
			u7 = -alfa131R*T131 - alfa132R*T132 + x7s;
			v7 = T131 + u7; 
			u6 = (T132 + u7); 
			u6s = u6/c14;
			u7s = u7/c13;
			% Adaptor VI -series
			u4 = x4s - alfa61R*(u6s - x6); 
			u5 = -(u4 + u6s);
			u5s = u5/c5;
			u4s = u4/c6; 
			% Adaptor V
			v6 = T52 + u5s; 
			v5 = T51 + v6; 
			% Adaptor IV
			v4 = T42 + u4s; 
			u3 = (T41 + v4);
			u3s = u3/c4;
			% Adaptor III -series
			u1 = (x1s - alfa31R*(u3s - x3)); 
			u2 = -(u1 + u3s); 
			u2s = u2/c2;
			u1s = u1/c3;
			% Adaptor II
			v3 = T22 + u2s; 
			v2 = T21 + v3; 
			% Adaptor I	
			v1 = T12 + u1s; 
			b1 = (T11 + v1);
			b1 = b1/c1;
			% Adaptor XII -series
			u8 = x8s - alfa121R*(u7s - x7); 
			u9 = -(u8 + u7s); 
			u9s = u9/c12;
			u8s = u8/c11;
			% Adaptor XI
			v9 = T112 + u8s; 
			v8 = T111 + v9; 
			% Adaptor X
			u10 = (T102 + u9s); 
			v10 = T101 + u10;
			u10s = u10/c10;
			% Adaptor IX -series
			u11 = x11s - alfa91R*(u10s - x10);
			u12 = -(u11 + u10s);
			u12s = u12/c9;
			u11s = u11/c8;
			% Adaptor VIII
			v12 = T82 + u11s; 
			v11 = T81 + v12; 
			% Adaptor VII
			b2 = T72 + u12s; 
			v13 = T71 + b2; 
			a1 = 0;			% reset the input
			h(n) = b2/c7;	
		end
		%		figure(3)
		%		PLOT_IMPULSE_RESPONSE_Z(h)	
		%		figure(4)
		[G, Z, P] = IMPULSE_2_P_Z(h, 9);
		Att = PZ_2_ATT_Z(G, Z, P, wT); 	
		subplot('position', [0.08 0.4 0.88 0.5]);
		plot(wT, Att-min(Att),'linewidth', 1);
		hold on
		
	end
	figure(1)
	
	zoom on
	axis([0 pi 0 80]);
	ylabel('{\itA}({\ite^j^\omega^T})  [dB]','FontName', fn,'FontSize', fs);
	xlabel('{\it\omegaT} [rad]','FontName', fn,'FontSize', fs);	
	set(gca,'FontName', fn,'FontSize', fs);
	ax = [0 0.1*pi 0.2*pi 0.3*pi 0.4*pi 0.5*pi 0.6*pi 0.7*pi 0.8*pi 0.9*pi pi];
	lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi';'0.7\pi';'0.8\pi';'0.9\pi';'\pi'};;
	xtick(ax,lab);
	grid on;
	%=====================
	figure(2)
	wT = linspace(0, 0.6*pi, 1000);
	for nn = 1:100
		alfa11R = alfa11 + delta*(rand(1,length(alfa11))-0.5);
		alfa21R = alfa21 + delta*(rand(1,length(alfa21))-0.5);
		alfa31R = alfa31 + delta*(rand(1,length(alfa31))-0.5);	
		alfa41R = alfa41 + delta*(rand(1,length(alfa41))-0.5);
		alfa51R = alfa51 + delta*(rand(1,length(alfa51))-0.5);
		alfa61R = alfa61 + delta*(rand(1,length(alfa61))-0.5);
		alfa71R = alfa71 + delta*(rand(1,length(alfa71))-0.5);
		alfa81R = alfa81 + delta*(rand(1,length(alfa81))-0.5);	
		alfa91R = alfa91 + delta*(rand(1,length(alfa91))-0.5);
		alfa101R = alfa101 + delta*(rand(1,length(alfa101))-0.5);
		alfa111R = alfa111 + delta*(rand(1,length(alfa111))-0.5);
		alfa121R = alfa121 + delta*(rand(1,length(alfa121))-0.5);
		alfa131R = alfa131 + delta*(rand(1,length(alfa131))-0.5);
		alfa132R = alfa132 + delta*(rand(1,length(alfa132))-0.5);
		%=====================================================
		
		a1 = 1; a2 = 0; v1 = 0; v2 = 0; v3 = 0; v4 = 0; v5 = 0; v6 = 0; 
		v7 = 0; v8 = 0; v9 = 0; v10 = 0; v11 = 0; v12 = 0; v13 = 0;
		for n = 1:20
			% Adaptor I
			T11 = v1 - a1*c1;
			T12 = -alfa11R*T11; 
			x1 = (T12 + v1); 
			x1s = x1*c3;
			% Adaptor II 
			T21 = v3 + v2;
			T22 = -alfa21R*T21; 
			x2 = (T22 + v3); 
			x2s = x2*c2;
			% Adaptor III - Series
			x3 = -(x1s + x2s);
			x3s = x3*c4;
			% Adaptor IV	
			T41 = v4 - x3s;
			T42 = -alfa41R*T41; 
			x4 = (T42 + v4);
			x4s = x4*c6;
			% Adaptor V
			T51 = v6 + v5;
			T52 = -alfa51R*T51; 
			x5 = (T52 + v6);
			x5s = x5*c5;
			% Adaptor VI - Series
			x6 = -(x4s + x5s);
			x6s = x6*c14;
			% Adaptor VII
			T71 = a2*c7 - v13; 
			T72 = -alfa71R*T71; 
			x12 = (T72 + a2*c7);
			x12s = x12*c9;
			% Adaptor VIII
			T81 = v12 + v11;
			T82 = -alfa81R*T81; 
			x11 = (T82 + v12);
			x11s = x11*c8;
			% Adaptor IX -series
			x10 = -(x11s + x12s);
			x10s = x10*c10;
			% Adaptor X	
			T101 = x10s - v10;
			T102 = -alfa101R*T101; 
			x9 = (T102 + x10s);
			x9s = x9*c12;
			% Adaptor XI
			T111 = v9 + v8; 
			T112 = -alfa111R*T111; 
			x8 = (T112 + v9);
			x8s = x8*c11;
			% Adaptor XII -series
			x7 = -(x8s + x9s);
			x7s = x7*c13;
			% Adaptor XIII
			T131 = x7s - v7; 
			T132 = x7s - x6s; 
			u7 = -alfa131R*T131 - alfa132R*T132 + x7s;
			v7 = T131 + u7; 
			u6 = (T132 + u7); 
			u6s = u6/c14;
			u7s = u7/c13;
			% Adaptor VI -series
			u4 = x4s - alfa61R*(u6s - x6); 
			u5 = -(u4 + u6s);
			u5s = u5/c5;
			u4s = u4/c6; 
			% Adaptor V
			v6 = T52 + u5s; 
			v5 = T51 + v6; 
			% Adaptor IV
			v4 = T42 + u4s; 
			u3 = (T41 + v4);
			u3s = u3/c4;
			% Adaptor III -series
			u1 = (x1s - alfa31R*(u3s - x3)); 
			u2 = -(u1 + u3s); 
			u2s = u2/c2;
			u1s = u1/c3;
			% Adaptor II
			v3 = T22 + u2s; 
			v2 = T21 + v3; 
			% Adaptor I	
			v1 = T12 + u1s; 
			b1 = (T11 + v1);
			b1 = b1/c1;
			% Adaptor XII -series
			u8 = x8s - alfa121R*(u7s - x7); 
			u9 = -(u8 + u7s); 
			u9s = u9/c12;
			u8s = u8/c11;
			% Adaptor XI
			v9 = T112 + u8s; 
			v8 = T111 + v9; 
			% Adaptor X
			u10 = (T102 + u9s); 
			v10 = T101 + u10;
			u10s = u10/c10;
			% Adaptor IX -series
			u11 = x11s - alfa91R*(u10s - x10);
			u12 = -(u11 + u10s);
			u12s = u12/c9;
			u11s = u11/c8;
			% Adaptor VIII
			v12 = T82 + u11s; 
			v11 = T81 + v12; 
			% Adaptor VII
			b2 = T72 + u12s; 
			v13 = T71 + b2; 
			a1 = 0;			% reset the input
			h(n) = b2/c7;	
		end
		%		figure(3)
		%		PLOT_IMPULSE_RESPONSE_Z(h)	
		%		figure(4)
		[G, Z, P] = IMPULSE_2_P_Z(h, 9);
		Att = PZ_2_ATT_Z(G, Z, P, wT); 	
		plot(wT, Att-min(Att),'linewidth', 1);
		hold on
		%	subplot('position', [0.08 0.4 0.88 0.4]);
		subplot('position', [0.1 0.4 0.88 0.5]);
	end


	zoom on
	axis([0 0.6*pi 0 0.2]);
	ylabel('{\itA}({\ite^j^\omega^T})  [dB]','FontName', fn,'FontSize', fs);
	xlabel('{\it\omegaT} [rad]','FontName', fn,'FontSize', fs);	
	set(gca,'FontName', fn,'FontSize', fs);
	ax = [0 0.1*pi 0.2*pi 0.3*pi 0.4*pi 0.5*pi 0.6*pi];
	lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi'};
	xtick(ax,lab);
	grid on;
	
	
	%		PLOT_PZ_Z(Z, P)
	%		zoom on
	%		figure(5)
	
	%	Taug = PZ_2_TG_Z(G, Z, P, wT);
	%		Taug(Taug < 0) = 0;
	%		PLOT_A_TG_Z(Att, Taug, wT, axis_Amax, axis_Tg_max)
	%		zoom on
	
	
	
